package gov.va.mhv.util.distributor;

import gov.va.mhv.util.distributor.message.BaseRequest;
/**
 * Factory Class that is used for getting new distributor objects based on information 
 * provided in the request bean. 
 *
 */
public class DistributorFactory {
	
	/**
	 * Requests a new instance of a Distributor based on your request bean.
	 * @param request
	 * @return
	 * @throws DistributorException
	 */
	public static Distributor newInstance(BaseRequest request) throws DistributorException{		
		return findDistributor(request);
	}

	/*
	 * Finds the appropriate distributor based on the URI.
	 */
	private static Distributor findDistributor(BaseRequest request) throws DistributorException{
		
		String[] prefix = request.getUri().split(":");
		
		//Maybe put in logic at some point to re-use the Object if there is already and instance created.
		if("http".equalsIgnoreCase(prefix[0])){
			return new HttpClientDistributor(request);
		}else{
			throw new DistributorException("Unknown URL prefix. Please check your URL address");
		}
	}
}
